/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.FontUtilities;

public class FontFamily {
    private static ConcurrentHashMap<String, FontFamily> familyNameMap = new ConcurrentHashMap();
    private static HashMap<String, FontFamily> allLocaleNames;
    protected String familyName;
    protected Font2D plain;
    protected Font2D bold;
    protected Font2D italic;
    protected Font2D bolditalic;
    protected boolean logicalFont = false;
    protected int familyRank;

    public static FontFamily getFamily(String string) {
        return familyNameMap.get(string.toLowerCase(Locale.ENGLISH));
    }

    public static String[] getAllFamilyNames() {
        return null;
    }

    static void remove(Font2D font2D) {
        String string = font2D.getFamilyName(Locale.ENGLISH);
        FontFamily fontFamily = FontFamily.getFamily(string);
        if (fontFamily == null) {
            return;
        }
        if (fontFamily.plain == font2D) {
            fontFamily.plain = null;
        }
        if (fontFamily.bold == font2D) {
            fontFamily.bold = null;
        }
        if (fontFamily.italic == font2D) {
            fontFamily.italic = null;
        }
        if (fontFamily.bolditalic == font2D) {
            fontFamily.bolditalic = null;
        }
        if (fontFamily.plain == null && fontFamily.bold == null && fontFamily.plain == null && fontFamily.bold == null) {
            familyNameMap.remove(string);
        }
    }

    public FontFamily(String string, boolean bl, int n) {
        this.logicalFont = bl;
        this.familyName = string;
        this.familyRank = n;
        familyNameMap.put(string.toLowerCase(Locale.ENGLISH), this);
    }

    FontFamily(String string) {
        this.logicalFont = false;
        this.familyName = string;
        this.familyRank = 4;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getRank() {
        return this.familyRank;
    }

    private boolean isFromSameSource(Font2D font2D) {
        if (!(font2D instanceof FileFont)) {
            return false;
        }
        FileFont fileFont = null;
        if (this.plain instanceof FileFont) {
            fileFont = (FileFont)this.plain;
        } else if (this.bold instanceof FileFont) {
            fileFont = (FileFont)this.bold;
        } else if (this.italic instanceof FileFont) {
            fileFont = (FileFont)this.italic;
        } else if (this.bolditalic instanceof FileFont) {
            fileFont = (FileFont)this.bolditalic;
        }
        if (fileFont == null) {
            return false;
        }
        File file = new File(fileFont.platName).getParentFile();
        FileFont fileFont2 = (FileFont)font2D;
        File file2 = new File(fileFont2.platName).getParentFile();
        return Objects.equals(file2, file);
    }

    public void setFont(Font2D font2D, int n) {
        if (font2D.getRank() > this.familyRank && !this.isFromSameSource(font2D)) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().warning("Rejecting adding " + font2D + " of lower rank " + font2D.getRank() + " to family " + this + " of rank " + this.familyRank);
            }
            return;
        }
        switch (n) {
            case 0: {
                this.plain = font2D;
                break;
            }
            case 1: {
                this.bold = font2D;
                break;
            }
            case 2: {
                this.italic = font2D;
                break;
            }
            case 3: {
                this.bolditalic = font2D;
                break;
            }
        }
    }

    public Font2D getFontWithExactStyleMatch(int n) {
        switch (n) {
            case 0: {
                return this.plain;
            }
            case 1: {
                return this.bold;
            }
            case 2: {
                return this.italic;
            }
            case 3: {
                return this.bolditalic;
            }
        }
        return null;
    }

    public Font2D getFont(int n) {
        switch (n) {
            case 0: {
                return this.plain;
            }
            case 1: {
                if (this.bold != null) {
                    return this.bold;
                }
                if (this.plain != null && this.plain.canDoStyle(n)) {
                    return this.plain;
                }
                return null;
            }
            case 2: {
                if (this.italic != null) {
                    return this.italic;
                }
                if (this.plain != null && this.plain.canDoStyle(n)) {
                    return this.plain;
                }
                return null;
            }
            case 3: {
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                if (this.italic != null && this.italic.canDoStyle(n)) {
                    return this.italic;
                }
                if (this.bold != null && this.bold.canDoStyle(n)) {
                    return this.italic;
                }
                if (this.plain != null && this.plain.canDoStyle(n)) {
                    return this.plain;
                }
                return null;
            }
        }
        return null;
    }

    Font2D getClosestStyle(int n) {
        switch (n) {
            case 0: {
                if (this.bold != null) {
                    return this.bold;
                }
                if (this.italic != null) {
                    return this.italic;
                }
                return this.bolditalic;
            }
            case 1: {
                if (this.plain != null) {
                    return this.plain;
                }
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                return this.italic;
            }
            case 2: {
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                if (this.plain != null) {
                    return this.plain;
                }
                return this.bold;
            }
            case 3: {
                if (this.italic != null) {
                    return this.italic;
                }
                if (this.bold != null) {
                    return this.bold;
                }
                return this.plain;
            }
        }
        return null;
    }

    static synchronized void addLocaleNames(FontFamily fontFamily, String[] stringArray) {
        if (allLocaleNames == null) {
            allLocaleNames = new HashMap();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            allLocaleNames.put(stringArray[i].toLowerCase(), fontFamily);
        }
    }

    public static synchronized FontFamily getLocaleFamily(String string) {
        if (allLocaleNames == null) {
            return null;
        }
        return allLocaleNames.get(string.toLowerCase());
    }

    public String toString() {
        return "Font family: " + this.familyName + " plain=" + this.plain + " bold=" + this.bold + " italic=" + this.italic + " bolditalic=" + this.bolditalic;
    }
}

